/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.formatter;

import icyllis.annotations.Nullable;
import icyllis.flexmark.formatter.Formatter;
import icyllis.flexmark.parser.Parser;
import icyllis.flexmark.parser.ParserEmulationProfile;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.format.CharWidthProvider;
import icyllis.flexmark.util.format.options.BlockQuoteMarker;
import icyllis.flexmark.util.format.options.CodeFenceMarker;
import icyllis.flexmark.util.format.options.DiscretionaryText;
import icyllis.flexmark.util.format.options.ElementAlignment;
import icyllis.flexmark.util.format.options.ElementPlacement;
import icyllis.flexmark.util.format.options.ElementPlacementSort;
import icyllis.flexmark.util.format.options.EqualizeTrailingMarker;
import icyllis.flexmark.util.format.options.HeadingStyle;
import icyllis.flexmark.util.format.options.ListBulletMarker;
import icyllis.flexmark.util.format.options.ListNumberedMarker;
import icyllis.flexmark.util.format.options.ListSpacing;
import java.util.regex.Pattern;

public class FormatterOptions {
    public final boolean itemContentIndent;
    public final ParserEmulationProfile emulationProfile;
    public final boolean setextHeadingEqualizeMarker;
    public final int formatFlags;
    public final int maxBlankLines;
    public final int maxTrailingBlankLines;
    public final int rightMargin;
    public final int minSetextMarkerLength;
    public final DiscretionaryText spaceAfterAtxMarker;
    public final EqualizeTrailingMarker atxHeadingTrailingMarker;
    public final HeadingStyle headingStyle;
    public final boolean blockQuoteBlankLines;
    public final BlockQuoteMarker blockQuoteMarkers;
    public final String thematicBreak;
    public final String translationIdFormat;
    public final String translationHtmlBlockPrefix;
    public final String translationHtmlInlinePrefix;
    public final String translationExcludePattern;
    public final String translationHtmlBlockTagPattern;
    public final String translationHtmlInlineTagPattern;
    public final String translationAutolinkPrefix;
    public final boolean indentedCodeMinimizeIndent;
    public final boolean fencedCodeMinimizeIndent;
    public final boolean fencedCodeMatchClosingMarker;
    public final boolean fencedCodeSpaceBeforeInfo;
    public final int fencedCodeMarkerLength;
    public final CodeFenceMarker fencedCodeMarkerType;
    public final boolean listAddBlankLineBefore;
    public final boolean listRenumberItems;
    public final boolean listRemoveEmptyItems;
    public final boolean listsItemContentAfterSuffix;
    public final ListBulletMarker listBulletMarker;
    public final ListNumberedMarker listNumberedMarker;
    public final ListSpacing listSpacing;
    public final ElementPlacement referencePlacement;
    public final ElementPlacementSort referenceSort;
    public final boolean keepImageLinksAtStart;
    public final boolean keepExplicitLinksAtStart;
    public final boolean keepHardLineBreaks;
    public final boolean keepSoftLineBreaks;
    public final boolean appendTransferredReferences;
    public final boolean optimizedInlineRendering;
    public final boolean applySpecialLeadInHandlers;
    public final boolean escapeSpecialCharsOnWrap;
    public final boolean escapeNumberedLeadInOnWrap;
    public final boolean unescapeSpecialCharsOnWrap;
    public final CharWidthProvider charWidthProvider;
    public final ElementAlignment listAlignNumeric;
    public final boolean listResetFirstItemNumber;
    public final String formatterOnTag;
    public final String formatterOffTag;
    public final boolean formatterTagsEnabled;
    public final boolean formatterTagsAcceptRegexp;
    public final boolean blankLinesInAst;
    @Nullable
    public final Pattern linkMarkerCommentPattern;

    public FormatterOptions(DataHolder options) {
        this.emulationProfile = Formatter.FORMATTER_EMULATION_PROFILE.get(options);
        this.itemContentIndent = this.emulationProfile.family != ParserEmulationProfile.FIXED_INDENT;
        this.setextHeadingEqualizeMarker = Formatter.SETEXT_HEADING_EQUALIZE_MARKER.get(options);
        this.formatFlags = Formatter.FORMAT_FLAGS.get(options);
        this.maxBlankLines = Formatter.MAX_BLANK_LINES.get(options);
        this.maxTrailingBlankLines = Formatter.MAX_TRAILING_BLANK_LINES.get(options);
        this.rightMargin = Formatter.RIGHT_MARGIN.get(options);
        this.minSetextMarkerLength = Parser.HEADING_SETEXT_MARKER_LENGTH.get(options);
        this.spaceAfterAtxMarker = Formatter.SPACE_AFTER_ATX_MARKER.get(options);
        this.atxHeadingTrailingMarker = Formatter.ATX_HEADING_TRAILING_MARKER.get(options);
        this.headingStyle = Formatter.HEADING_STYLE.get(options);
        this.thematicBreak = Formatter.THEMATIC_BREAK.get(options);
        this.translationIdFormat = Formatter.TRANSLATION_ID_FORMAT.get(options);
        this.translationHtmlBlockPrefix = Formatter.TRANSLATION_HTML_BLOCK_PREFIX.get(options);
        this.translationHtmlInlinePrefix = Formatter.TRANSLATION_HTML_INLINE_PREFIX.get(options);
        this.translationAutolinkPrefix = Formatter.TRANSLATION_AUTOLINK_PREFIX.get(options);
        this.translationExcludePattern = Formatter.TRANSLATION_EXCLUDE_PATTERN.get(options);
        this.translationHtmlBlockTagPattern = Formatter.TRANSLATION_HTML_BLOCK_TAG_PATTERN.get(options);
        this.translationHtmlInlineTagPattern = Formatter.TRANSLATION_HTML_INLINE_TAG_PATTERN.get(options);
        this.blockQuoteBlankLines = Formatter.BLOCK_QUOTE_BLANK_LINES.get(options);
        this.blockQuoteMarkers = Formatter.BLOCK_QUOTE_MARKERS.get(options);
        this.indentedCodeMinimizeIndent = Formatter.INDENTED_CODE_MINIMIZE_INDENT.get(options);
        this.fencedCodeMinimizeIndent = Formatter.FENCED_CODE_MINIMIZE_INDENT.get(options);
        this.fencedCodeMatchClosingMarker = Formatter.FENCED_CODE_MATCH_CLOSING_MARKER.get(options);
        this.fencedCodeSpaceBeforeInfo = Formatter.FENCED_CODE_SPACE_BEFORE_INFO.get(options);
        this.fencedCodeMarkerLength = Formatter.FENCED_CODE_MARKER_LENGTH.get(options);
        this.fencedCodeMarkerType = Formatter.FENCED_CODE_MARKER_TYPE.get(options);
        this.listAddBlankLineBefore = Formatter.LIST_ADD_BLANK_LINE_BEFORE.get(options);
        this.listAlignNumeric = Formatter.LIST_ALIGN_NUMERIC.get(options);
        this.listResetFirstItemNumber = Formatter.LIST_RESET_FIRST_ITEM_NUMBER.get(options);
        this.listRenumberItems = Formatter.LIST_RENUMBER_ITEMS.get(options);
        this.listRemoveEmptyItems = Formatter.LIST_REMOVE_EMPTY_ITEMS.get(options);
        this.listBulletMarker = Formatter.LIST_BULLET_MARKER.get(options);
        this.listNumberedMarker = Formatter.LIST_NUMBERED_MARKER.get(options);
        this.listSpacing = Formatter.LIST_SPACING.get(options);
        this.listsItemContentAfterSuffix = Formatter.LISTS_ITEM_CONTENT_AFTER_SUFFIX.get(options);
        this.referencePlacement = Formatter.REFERENCE_PLACEMENT.get(options);
        this.referenceSort = Formatter.REFERENCE_SORT.get(options);
        this.keepImageLinksAtStart = Formatter.KEEP_IMAGE_LINKS_AT_START.get(options);
        this.keepExplicitLinksAtStart = Formatter.KEEP_EXPLICIT_LINKS_AT_START.get(options);
        this.charWidthProvider = Formatter.FORMAT_CHAR_WIDTH_PROVIDER.get(options);
        this.keepHardLineBreaks = Formatter.KEEP_HARD_LINE_BREAKS.get(options);
        this.keepSoftLineBreaks = Formatter.KEEP_SOFT_LINE_BREAKS.get(options);
        this.formatterOnTag = Formatter.FORMATTER_ON_TAG.get(options);
        this.formatterOffTag = Formatter.FORMATTER_OFF_TAG.get(options);
        this.formatterTagsEnabled = Formatter.FORMATTER_TAGS_ENABLED.get(options);
        this.formatterTagsAcceptRegexp = Formatter.FORMATTER_TAGS_ACCEPT_REGEXP.get(options);
        this.linkMarkerCommentPattern = Formatter.LINK_MARKER_COMMENT_PATTERN.get(options);
        this.appendTransferredReferences = Formatter.APPEND_TRANSFERRED_REFERENCES.get(options);
        this.optimizedInlineRendering = Formatter.OPTIMIZED_INLINE_RENDERING.get(options);
        this.applySpecialLeadInHandlers = Formatter.APPLY_SPECIAL_LEAD_IN_HANDLERS.get(options);
        this.escapeSpecialCharsOnWrap = Formatter.ESCAPE_SPECIAL_CHARS.get(options);
        this.escapeNumberedLeadInOnWrap = Formatter.ESCAPE_NUMBERED_LEAD_IN.get(options);
        this.unescapeSpecialCharsOnWrap = Formatter.UNESCAPE_SPECIAL_CHARS.get(options);
        this.blankLinesInAst = Parser.BLANK_LINES_IN_AST.get(options);
    }
}

